--[[----------------------------------------------------------------------------

$File: //shadowland/releases/3.2/main/plugins/tether_leica_s2/source/LeicaTetherUtils.lua $

$Date: 2010/07/21 $
$Author: ktieskoe $

--------------------------------------------------------------------------------

ADOBE CONFIDENTIAL
------------------
Copyright 2009 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

----------------------------------------------------------------------------]]--

local logger = import "LrLogger"( "LeicaTetherTask" )


LeicaTetherUtils = {}

--------------------------------------------------------------------------------

LeicaTetherUtils.postProcessCameraSettings = function( settings )
	
	import 'LrTableUtils'.debugDumpTable( settings, "LeicaTetherUtils.postProcessCameraSettings" )

	for k, v in pairs( settings ) do
		local funcName = "postProcess_" .. k
		if LeicaTetherUtils[ funcName ] then
			settings[ k ] = LeicaTetherUtils[ funcName ]( v, settings ) or settings[ k ]
		end
	end
	
	return settings
end

--------------------------------------------------------------------------------

LeicaTetherUtils.postProcess_aperture = function( aperture, settings )
	if not LeicaTetherUtils.apertureMap then
		LeicaTetherUtils.apertureMap = {
			{ from = -77, to = 0.9 },
			{ from = 0, to = 1.0 },
			{ from = 72, to = 1.1 },
			{ from = 128, to = 1.2 },
			{ from = 195, to = 1.3 },
			{ from = 256, to = 1.4 },
			{ from = 300, to = 1.5 },
			{ from = 348, to = 1.6 },
			{ from = 384, to = 1.7 },
			{ from = 435, to = 1.8 },
			{ from = 474, to = 1.9 },
			{ from = 512, to = 2.0 },
			{ from = 548, to = 2.1 },
			{ from = 584, to = 2.2 },
			{ from = 614, to = 2.3 },
			{ from = 640, to = 2.4 },
			{ from = 676, to = 2.5 },
			{ from = 707, to = 2.6 },
			{ from = 735, to = 2.7 },
			{ from = 768, to = 2.8 },
			{ from = 786, to = 2.9 },
			{ from = 812, to = 3.0 },
			{ from = 835, to = 3.1 },
			{ from = 860, to = 3.2 },
			{ from = 881, to = 3.3 },
			{ from = 896, to = 3.4 },
			{ from = 924, to = 3.5 },
			{ from = 947, to = 3.6 },
			{ from = 968, to = 3.7 },
			{ from = 986, to = 3.8 },
			{ from = 1006, to = 3.9 },
			{ from = 1024, to = 4.0 },
			{ from = 1042, to = 4.1 },
			{ from = 1060, to = 4.2 },
			{ from = 1078, to = 4.3 },
			{ from = 1096, to = 4.4 },
			{ from = 1111, to = 4.5 },
			{ from = 1126, to = 4.6 },
			{ from = 1144, to = 4.7 },
			{ from = 1152, to = 4.8 },
			{ from = 1175, to = 4.9 },
			{ from = 1188, to = 5.0 },
			{ from = 1203, to = 5.1 },
			{ from = 1219, to = 5.2 },
			{ from = 1231, to = 5.3 },
			{ from = 1247, to = 5.4 },
			{ from = 1260, to = 5.5 },
			{ from = 1280, to = 5.6 },
			{ from = 1285, to = 5.7 },
			{ from = 1298, to = 5.8 },
			{ from = 1311, to = 5.9 },
			{ from = 1324, to = 6.0 },
			{ from = 1336, to = 6.1 },
			{ from = 1347, to = 6.2 },
			{ from = 1359, to = 6.3 },
			{ from = 1372, to = 6.4 },
			{ from = 1382, to = 6.5 },
			{ from = 1393, to = 6.6 },
			{ from = 1405, to = 6.7 },
			{ from = 1408, to = 6.8 },
			{ from = 1426, to = 6.9 },
			{ from = 1436, to = 7.0 },
			{ from = 1449, to = 7.1 },
			{ from = 1459, to = 7.2 },
			{ from = 1469, to = 7.3 },
			{ from = 1480, to = 7.4 },
			{ from = 1487, to = 7.5 },
			{ from = 1498, to = 7.6 },
			{ from = 1508, to = 7.7 },
			{ from = 1518, to = 7.8 },
			{ from = 1526, to = 7.9 },
			{ from = 1536, to = 8.0 },
			{ from = 1623, to = 9.0 },
			{ from = 1664, to = 9.5 },
			{ from = 1700, to = 10.0 },
			{ from = 1792, to = 11.0 },
			{ from = 1836, to = 12 },
			{ from = 1920, to = 13 },
			{ from = 1999, to = 15 },
			{ from = 2048, to = 16 },
			{ from = 2135, to = 18 },
			{ from = 2176, to = 19 },
			{ from = 2212, to = 20 },
			{ from = 2304, to = 22 },
			{ from = 2378, to = 25 },
			{ from = 2432, to = 27 },
			{ from = 2488, to = 29 },
			{ from = 2560, to = 32 },
			{ from = 2647, to = 36 },
			{ from = 2688, to = 38 },
			{ from = 2744, to = 41 },
			{ from = 2816, to = 45 },
			{ from = 2903, to = 51 },
			{ from = 2944, to = 54 },
			{ from = 3000, to = 58 },
			{ from = 3072, to = 64 },
		}
	end
	
	if settings.exposureMode == 1 or settings.exposureMode == 3 then
		return LOC( "$$$/AgTether/Leica/ExposureMode/Auto=Auto" )
	end
	
	local lastValue = nil
	for i, v in ipairs( LeicaTetherUtils.apertureMap ) do
		lastValue = v.to
		if aperture <= v.from then
			break
		end
	end
	
	return lastValue or aperture
	
end

--------------------------------------------------------------------------------

LeicaTetherUtils.postProcess_shutter = function( shutter, settings )
	if not LeicaTetherUtils.shutterMap then
		LeicaTetherUtils.shutterMap = {
			{ from = -1216, to = "32" },
			{ from = -1088, to = "24" },
			{ from = -960, to = "16" },
			{ from = -832, to = "12" },
			{ from = -704, to = "8" },
			{ from = -576, to = "6" },
			{ from = -448, to = "4" },
			{ from = -320, to = "3" },
			{ from = -192, to = "2" },
			{ from = -64, to = "1.5" },
			{ from = 64, to = "1" },
			{ from = 192, to = "0.7" },
			{ from = 320, to = "1/2" },
			{ from = 448, to = "1/3" },
			{ from = 576, to = "1/4" },
			{ from = 704, to = "1/6" },
			{ from = 832, to = "1/8" },
			{ from = 960, to = "1/12" },
			{ from = 1088, to = "1/15" },
			{ from = 1216, to = "1/24" },
			{ from = 1344, to = "1/30" },
			{ from = 1472, to = "1/45" },
			{ from = 1600, to = "1/60" },
			{ from = 1728, to = "1/90" },
			{ from = 1856, to = "1/125" },
			{ from = 1984, to = "1/180" },
			{ from = 2112, to = "1/250" },
			{ from = 2240, to = "1/360" },
			{ from = 2368, to = "1/500" },
			{ from = 2496, to = "1/750" },
			{ from = 2624, to = "1/1000" },
			{ from = 2752, to = "1/1500" },
			{ from = 2880, to = "1/2000" },
			{ from = 3008, to = "1/3000" },
			{ from = 3136, to = "1/4000" },
		}
	end
	
	if settings.exposureMode == 2 or settings.exposureMode == 3 then
		return LOC( "$$$/AgTether/Leica/ExposureMode/Auto=Auto" )
	end
	
	if settings.exposureMode == 4 then
		return LOC( "$$$/AgTether/Leica/ExposureMode/Bulb=Bulb" )
	end
	
	local lastValue = nil
	for i, v in ipairs( LeicaTetherUtils.shutterMap ) do
		lastValue = v.to
		if shutter <= v.from then
			break
		end
	end
	
	return lastValue or shutter
	
end

--------------------------------------------------------------------------------

LeicaTetherUtils.postProcess_exposureMode = function( exposureMode, settings )
	if not LeicaTetherUtils.exposureModeMap then
		LeicaTetherUtils.exposureModeMap = {}
		
		local map = LeicaTetherUtils.exposureModeMap
		
		map[ 0 ] = LOC( "$$$/AgTether/Leica/ExposureMode/Auto=Auto" )
		map[ 1 ] = LOC( "$$$/AgTether/Leica/ExposureMode/Aperture=Aperture" )
		map[ 2 ] = LOC( "$$$/AgTether/Leica/ExposureMode/Time=Time" )
		map[ 3 ] = LOC( "$$$/AgTether/Leica/ExposureMode/Program=Program" )
		map[ 4 ] = LOC( "$$$/AgTether/Leica/ExposureMode/Bulb=Bulb" )
		
	end
	
	return LeicaTetherUtils.exposureModeMap[ exposureMode ] or 0

end

--------------------------------------------------------------------------------

LeicaTetherUtils.postProcess_whiteBalance = function( whiteBalance )
	if not LeicaTetherUtils.whiteBalanceMap then
		LeicaTetherUtils.whiteBalanceMap = {}

		local map = LeicaTetherUtils.whiteBalanceMap
		
		map[ 0 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Auto=Auto" )
		map[ 1 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Daylight=Daylight" )
		map[ 2 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Cloudy=Cloudy" )
		map[ 3 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Shadow=Shadow" )
		map[ 4 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Tungsten=Tungsten" )
		map[ 5 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/NeonWarm=Fl Warm" )
		map[ 6 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/NeonCool=Fl Cool" )
		map[ 7 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Flash=Flash" )
		map[ 8 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/Manual=Manual" )
		map[ 9 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/ColorTemp=Color Temp" )
		map[ 10 ] = LOC( "$$$/AgTether/Leica/WhiteBalance/HMI=HMI" )
	end
	
	logger:tracef( "white balance: %s - %s", whiteBalance, LeicaTetherUtils.whiteBalanceMap[ whiteBalance ] )
	
	return LeicaTetherUtils.whiteBalanceMap[ whiteBalance ] or 0
end

--------------------------------------------------------------------------------





